//**************************************************************************/
/*                                            COPYRIGHT (c) FREESCALE 2006 */
/* PROJECT NAME :Lance(MPC5561) EVB silicon Evaluation                    */
/* INCLUDE FILES: MPC5561.h typedefs.h fs_gpio.h			              */
/* VERSION: 0.1                                                           */
/*                                                                        */
/*========================================================================*/
/*                                                                        */
/* DESCRIPTION: Communication from DSPI B and DSPI C to external DSPI B   */
/* and DSPI C modules. Contains FFT results variables.                    */
/*                                                                        */
/*========================================================================*/
/*                                                                        */
/* AUTHOR: David Paterson                   CREATION DATE: 02/Feb/07      */
/* LOCATION: East Kilbride, Scotland.                                     */
/*                                                                        */
/*                                                                        */
/**************************************************************************/
 
#include "mpc5561.h"
#include "typedefs.h"
#include "fs_gpio.h"     // GPIO API for the MPC5500 family

#define DSPIB_PUSHR  0xFFF94034
#define DSPIC_PUSHR  0xFFF98034

#define DSPIB_POPR   0xFFF94038
#define DSPIC_POPR   0xFFF98038

extern int highest_freq;
extern int highest_freq1;

vuint32_t DSPI_TXQUEUE[2];    						// Set up a command queue for DSPI B transmit
vuint32_t DSPI_TXQUEUE1[2];    						// Set up a command queue for DSPI C transmit

void initDMA(void);
void initDSPI(void);
void config_pins(void);
void DSPI_test(void);

/*****************************************************************************
*	Function Name: 	DSPI_test										 		 *
*	Description: 	This sets up data to be send and enables eDMA request	 *
*	Called By :		edma_ch3_ISR										 	 *
*****************************************************************************/
void DSPI_test(void)
{
  	//Set TXQUEUE[0] to FFT result
	DSPI_TXQUEUE[0] = (0x00010000 + highest_freq);	
  	DSPI_TXQUEUE[1] = 0x0001feed;
  	
  	//Set TXQUEUE1[0] to FFT result
  	DSPI_TXQUEUE1[0] = (0x00010000 + highest_freq1);	
  	DSPI_TXQUEUE1[1] = 0x0001feed;
  	
  	EDMA.SERQR.R = 12;      							// Enable EDMA channel 12 
  	EDMA.SERQR.R = 14;      							// Enable EDMA channel 14 
  	
  	while ((EDMA.IRQRL.B.INT12 ==0)||(EDMA.IRQRL.B.INT14 ==0)) 
  	{} 												   //wait for the DMA to be done 
  
}

/*************************************************************************
*	Function Name: 	setup_DSPI										 	 *
*	Description: 	This configures DSPI external pins, sets up eDMA	 *
*					and DSPI module										 *
*	Called By :		setup_functions										 *
**************************************************************************/
void setup_DSPI(void) 
{	
  config_pins();		// Configure DSPI pins 
  initDMA();			// Setup eDMA 
  initDSPI();			// Initialize DSPI modules
}


/*************************************************************************
*	Function Name: 	initDMA										 		 *
*	Description: 	This sets up the eDMA to transfer data to DSPI		 *
*					push registers										 *
*	Called By :		setup_DSPI										 	 *
**************************************************************************/
void initDMA(void)
{
// DMA Configuration Register (DMACR)                     
     	EDMA.CR.R   = 0x00000400;  // Channel group 1 priority. Group 1 priority level when fixed priority group arbitration is enabled. 
                                 
// DMA Enable Error Interrupt Request Registers (DMAEEIL)                     
     	EDMA.EEIRL.R   = 0x00000000;  // DMA Error Interrupt Enable Register Low (Channels 0-31) : 

// DMA Channel Priority Register Settings (DCHPRIn) Channels 0 - 63                     
          EDMA.CPR[0].R = 0x00;    // Channel 0 is Priority 1, Channel Preemption is Disabled
          EDMA.CPR[1].R = 0x01;    // Channel 1 is Priority 2, Channel Preemption is Disabled
          EDMA.CPR[2].R = 0x02;    // Channel 2 is Priority 3, Channel Preemption is Disabled
          EDMA.CPR[3].R = 0x03;    // Channel 3 is Priority 4, Channel Preemption is Disabled
          EDMA.CPR[4].R = 0x04;    // Channel 4 is Priority 5, Channel Preemption is Disabled
          EDMA.CPR[5].R = 0x05;    // Channel 5 is Priority 6, Channel Preemption is Disabled
          EDMA.CPR[6].R = 0x06;    // Channel 6 is Priority 7, Channel Preemption is Disabled
          EDMA.CPR[7].R = 0x07;    // Channel 7 is Priority 8, Channel Preemption is Disabled
          EDMA.CPR[8].R = 0x08;    // Channel 8 is Priority 9, Channel Preemption is Disabled
          EDMA.CPR[9].R = 0x09;    // Channel 9 is Priority 10, Channel Preemption is Disabled
          EDMA.CPR[10].R = 0x0A;    // Channel 10 is Priority 11, Channel Preemption is Disabled
          EDMA.CPR[11].R = 0x0B;    // Channel 11 is Priority 12, Channel Preemption is Disabled
          EDMA.CPR[12].R = 0x0C;    // Channel 12 is Priority 13, Channel Preemption is Disabled
          EDMA.CPR[13].R = 0x0D;    // Channel 13 is Priority 14, Channel Preemption is Disabled
          EDMA.CPR[14].R = 0x0E;    // Channel 14 is Priority 15, Channel Preemption is Disabled
          EDMA.CPR[15].R = 0x0F;    // Channel 15 is Priority 16, Channel Preemption is Disabled
          EDMA.CPR[16].R = 0x00;    // Channel 16 is Priority 1, Channel Preemption is Disabled
          EDMA.CPR[17].R = 0x01;    // Channel 17 is Priority 2, Channel Preemption is Disabled
          EDMA.CPR[18].R = 0x02;    // Channel 18 is Priority 3, Channel Preemption is Disabled
          EDMA.CPR[19].R = 0x03;    // Channel 19 is Priority 4, Channel Preemption is Disabled
          EDMA.CPR[20].R = 0x04;    // Channel 20 is Priority 5, Channel Preemption is Disabled
          EDMA.CPR[21].R = 0x05;    // Channel 21 is Priority 6, Channel Preemption is Disabled
          EDMA.CPR[22].R = 0x06;    // Channel 22 is Priority 7, Channel Preemption is Disabled
          EDMA.CPR[23].R = 0x07;    // Channel 23 is Priority 8, Channel Preemption is Disabled
          EDMA.CPR[24].R = 0x08;    // Channel 24 is Priority 9, Channel Preemption is Disabled
          EDMA.CPR[25].R = 0x09;    // Channel 25 is Priority 10, Channel Preemption is Disabled
          EDMA.CPR[26].R = 0x0A;    // Channel 26 is Priority 11, Channel Preemption is Disabled
          EDMA.CPR[27].R = 0x0B;    // Channel 27 is Priority 12, Channel Preemption is Disabled
          EDMA.CPR[28].R = 0x0C;    // Channel 28 is Priority 13, Channel Preemption is Disabled
          EDMA.CPR[29].R = 0x0D;    // Channel 29 is Priority 13, Channel Preemption is Disabled
          EDMA.CPR[30].R = 0x0E;    // Channel 30 is Priority 15, Channel Preemption is Disabled
          EDMA.CPR[31].R = 0x0F;    // Channel 31 is Priority 16, Channel Preemption is Disabled

//  Transfer Control Descriptor for DSPI B TFFF
    
            EDMA.TCD[12].SADDR = (vuint32_t) &DSPI_TXQUEUE[0];          //  Start Address 
      		EDMA.TCD[12].DADDR = DSPIB_PUSHR;         //  Destination address 
            EDMA.TCD[12].SMOD = 0x00;                 //  Source address modulo 
            EDMA.TCD[12].DMOD = 0x00;                 //  Destination address modulo 
            EDMA.TCD[12].DSIZE = 0x02;                //  Destination transfer size : 32 Bits 
            EDMA.TCD[12].SSIZE = 0x02;                //  Source transfer size : 32 Bits 
            EDMA.TCD[12].SOFF = 0x4;                  //  Signed source address offset 
            EDMA.TCD[12].NBYTES = 0x4;                //  Inner "minor" byte count 
            EDMA.TCD[12].SLAST = -0x8;          	  //  last Signed source address adjust                  
			EDMA.TCD[12].DOFF = 0x0;                  //  Signed destination address offset 
            EDMA.TCD[12].DLAST_SGA = 0x0;             //  Signed destination address adjust
            EDMA.TCD[12].BITERE_LINK = 0x0;  
            EDMA.TCD[12].BITER = 0x2;                 //  begining "major" iteration count 
            EDMA.TCD[12].CITERE_LINK = 0x0;                         
            EDMA.TCD[12].CITER=0x2;                   //  Current "major" iteration count Disabled
            EDMA.TCD[12].BWC = 0x00;                  //  Bandwidth control :  No DMA Stalls 
            EDMA.TCD[12].MAJORLINKCH = 0x00;          //  Major Channel number 
            EDMA.TCD[12].MAJORE_LINK = 0x0;           //  Major Channel Link : Disabled
            EDMA.TCD[12].DONE = 0x00;                 //  Channel Done 
            EDMA.TCD[12].ACTIVE = 0x00;               //  Channel ACtive
            EDMA.TCD[12].E_SG = 0x0;                  //  Enable Scatter/Gather : Disabled
            EDMA.TCD[12].D_REQ = 0x1;                 //  Do disable TCD When done  
            EDMA.TCD[12].INT_HALF = 0x0;              //  Interrupt on minor loop count : Disabled
            EDMA.TCD[12].INT_MAJ = 0x1;               //  Interrupt on major loop completion : Enabled
            EDMA.TCD[12].START = 0x00;                //  Explicit Channel Start bit
                        
            //  Transfer Control Descriptor for DSPI C TFFF
            
            EDMA.TCD[14].SADDR = (vuint32_t) &DSPI_TXQUEUE1[0];          //  Start Address 
      		EDMA.TCD[14].DADDR = DSPIC_PUSHR;         //  Destination address 
            EDMA.TCD[14].SMOD = 0x00;                 //  Source address modulo 
            EDMA.TCD[14].DMOD = 0x00;                 //  Destination address modulo 
            EDMA.TCD[14].DSIZE = 0x02;                //  Destination transfer size : 32 Bits 
            EDMA.TCD[14].SSIZE = 0x02;                //  Source transfer size : 32 Bits 
            EDMA.TCD[14].SOFF = 0x4;                  //  Signed source address offset 
            EDMA.TCD[14].NBYTES = 0x4;         	      //  Inner "minor" byte count 
            EDMA.TCD[14].SLAST = -0x8;          	  //  last Signed source address adjust                  
			EDMA.TCD[14].DOFF = 0x0;                  //  Signed destination address offset 
            EDMA.TCD[14].DLAST_SGA = 0x0;             //  Signed destination address adjust
            EDMA.TCD[14].BITERE_LINK = 0x0;  
            EDMA.TCD[14].BITER = 0x2;                 //  begining "major" iteration count 
            EDMA.TCD[14].CITERE_LINK = 0x0;                         
            EDMA.TCD[14].CITER=0x2;                   //  Current "major" iteration count Disabled
            EDMA.TCD[14].BWC = 0x00;                  //  Bandwidth control :  No DMA Stalls 
            EDMA.TCD[14].MAJORLINKCH = 0x00;          //  Major Channel number 
            EDMA.TCD[14].MAJORE_LINK = 0x0;           //  Major Channel Link : Disabled
            EDMA.TCD[14].DONE = 0x00;                 //  Channel Done 
            EDMA.TCD[14].ACTIVE = 0x00;               //  Channel ACtive
            EDMA.TCD[14].E_SG = 0x0;                  //  Enable Scatter/Gather : Disabled
            EDMA.TCD[14].D_REQ = 0x1;                 //  Do disable TCD When done 
            EDMA.TCD[14].INT_HALF = 0x0;              //  Interrupt on minor loop count : Disabled
            EDMA.TCD[14].INT_MAJ = 0x1;               //  Interrupt on major loop completion : Enabled
            EDMA.TCD[14].START = 0x00;                //  Explicit Channel Start bit
                        
}

/*************************************************************************
*	Function Name: 	initDSPI										 	 *
*	Description: 	This configures DSPI B & C modules					 *
*	Called By :		setup_DSPI										 	 *
**************************************************************************/
void initDSPI(void) 
 { 
  /******	SPI B and C using external connections *********/

  DSPI_B.MCR.R		= 0x80010000;	/* SPI mode DSPIB = Master PCS0=active lo*/
  DSPI_B.CTAR[0].R 	= 0x78003255;	/* FSIZE =4,CPOL=0,CPHA=0 LSBE=0 PCSSCK=0 CSSCK=3 PASC=0ASC=2PDT=0DT=5 PBR =0 BR=4 */
  
  DSPI_C.MCR.R		= 0x80010000;	/* SPI mode DSPIC = Master PCS0=active lo*/
  DSPI_C.CTAR[0].R 	= 0x78003255;	/* FSIZE =4,CPOL=0,CPHA=0 LSBE=0 PCSSCK=0 CSSCK=3 PASC=0ASC=2PDT=0DT=5 PBR =0 BR=4 */

  SIU.DISR.R 		= 0x00000000;	/* EXTERNAL CONNECTIONS REQ'D*/
  DSPI_B.RSER.R		= 0x03000000;	/* Setup TFFF to cause DMA transfer */	
  DSPI_C.RSER.R		= 0x03000000;	/* Setup TFFF to cause DMA transfer */	 
  }

/*************************************************************************
*	Function Name: 	config_pins											 *
*	Description: 	This configures all DSPI B & C pins					 *
*	Called By :		setup_DSPI											 *
**************************************************************************/
void config_pins()
{
  fs_gpio_config( FS_GPIO_SOUTB, FS_GPIO_PRIMARY_FUNCTION   + FS_GPIO_MAXIMUM_SLEW_RATE + FS_GPIO_OUTPUT_DRAIN_DISABLE + FS_GPIO_READBACK_ENABLE + FS_GPIO_OUTPUT_BUFFER_ENABLE);    //SOUTB
  fs_gpio_config( FS_GPIO_SCKB,  FS_GPIO_PRIMARY_FUNCTION   + FS_GPIO_MAXIMUM_SLEW_RATE + FS_GPIO_OUTPUT_DRAIN_DISABLE + FS_GPIO_READBACK_ENABLE + FS_GPIO_OUTPUT_BUFFER_ENABLE);    //SCKB 
  fs_gpio_config( FS_GPIO_PCSB0, FS_GPIO_PRIMARY_FUNCTION   + FS_GPIO_MAXIMUM_SLEW_RATE + FS_GPIO_OUTPUT_DRAIN_DISABLE + FS_GPIO_READBACK_ENABLE + FS_GPIO_OUTPUT_BUFFER_ENABLE);    //PCSB0
  fs_gpio_config( FS_GPIO_SINB,  FS_GPIO_PRIMARY_FUNCTION   + FS_GPIO_MAXIMUM_SLEW_RATE + FS_GPIO_OUTPUT_DRAIN_DISABLE                           + FS_GPIO_INPUT_BUFFER_ENABLE);     //SINB 
                                                                                                                                                                                     
  fs_gpio_config( FS_GPIO_PCSB3, FS_GPIO_ALTERNATE_FUNCTION + FS_GPIO_MAXIMUM_SLEW_RATE + FS_GPIO_OUTPUT_DRAIN_DISABLE                           + FS_GPIO_INPUT_BUFFER_ENABLE);     //SINC 
  fs_gpio_config( FS_GPIO_PCSB2, FS_GPIO_ALTERNATE_FUNCTION + FS_GPIO_MAXIMUM_SLEW_RATE + FS_GPIO_OUTPUT_DRAIN_DISABLE + FS_GPIO_READBACK_ENABLE + FS_GPIO_OUTPUT_BUFFER_ENABLE);    //SOUTC
  fs_gpio_config( FS_GPIO_PCSB4, FS_GPIO_ALTERNATE_FUNCTION + FS_GPIO_MAXIMUM_SLEW_RATE + FS_GPIO_OUTPUT_DRAIN_DISABLE + FS_GPIO_READBACK_ENABLE + FS_GPIO_OUTPUT_BUFFER_ENABLE);    //SCKC 
  fs_gpio_config( FS_GPIO_PCSB5, FS_GPIO_ALTERNATE_FUNCTION + FS_GPIO_MAXIMUM_SLEW_RATE + FS_GPIO_OUTPUT_DRAIN_DISABLE + FS_GPIO_READBACK_ENABLE + FS_GPIO_OUTPUT_BUFFER_ENABLE);    //PCSC0

  }                  